<?php

if (!defined('_CAN_LOAD_FILES_'))
    exit;

class SantanderCredit extends PaymentModule {

    private $_html = '';
    private $_errorsArray = array();
    private $shopTestId = '99995';

    public function __construct() {

        $this->name = 'santandercredit';
        $this->tab = 'payments_gateways';
        $this->version = 2.0;
        $this->author = 'Santander & OSCDeveloper.pl Arkadiusz Krakiewicz';

        parent::__construct();

        $this->page = basename(__FILE__, '.php');
        $this->displayName = $this->l('Santander - System ratalny');
        $this->description = $this->l('Santander - Zakupy na raty w internecie');
    }

    public function install() {

        if (
                !parent::install() ||
                !Configuration::updateValue('SANTANDERCREDIT_SHOP_ID', $this->shopTestId) ||
                !Configuration::updateValue('SANTANDERCREDIT_BLOCK', 'left') ||
                !Configuration::updateValue('SANTANDERCREDIT_BLOCK_TITLE', 'eRaty Santander Consumer Bank') ||
                !Configuration::updateValue('SANTANDERCREDIT_SYMULATOR', 'tak') ||
                !$this->registerHook('payment') ||
                !$this->registerHook('paymentReturn') ||
                !$this->registerHook('rightColumn') ||
                !$this->registerHook('leftColumn') ||
                !$this->registerHook('shoppingCart') ||
                !$this->registerHook('productActions') ||
                !$this->createOrderState() ||
                !Configuration::updateValue('SANTANDERCREDIT_USE_ORDER_STATE', 'SANTANDERCREDIT_OS_AUTHORIZATION')
        ) {

            return false;
        }

        return true;
    }

    public function uninstall() {

        if (
                !Configuration::deleteByName('SANTANDERCREDIT_SHOP_ID') ||
                !Configuration::deleteByName('SANTANDERCREDIT_BLOCK') ||
                !Configuration::deleteByName('SANTANDERCREDIT_BLOCK_TITLE') ||
                !Configuration::deleteByName('SANTANDERCREDIT_SYMULATOR') ||
                !parent::uninstall()
        ) {

            return false;
        }

        return true;
    }

    public function getContent() {

        $this->_html = '<h2>Zakupy na raty z systemem ratalnym Santander</h2>';

        if (isset($_POST['santanderCreditSubmit'])) {


            if (empty($_POST['santanderCreditShopId'])) {

                $this->_errorsArray[] = $this->l('Musisz podać id sklepu w systemie eRaty Santander');
            } else if (!Validate::isUnsignedInt($_POST['santanderCreditShopId'])) {

                $this->_errorsArray[] = $this->l('Numer sklepu musi być liczbą.');
            }


            $santanderCreditBlock = $_POST['santanderCreditBlock'];
            $santanderCreditBlockTitle = $_POST['santanderCreditBlockTitle'];
            $santanderCreditSymulator = $_POST['santanderCreditSymulator'];
//            SANTANDERCREDIT_USE_ORDER_STATE
            $santanderCreditUseOrderState = $_POST['santanderCreditUseOrderState'];            

            if (!sizeof($this->_errorsArray)) {

                Configuration::updateValue('SANTANDERCREDIT_SHOP_ID', intval($_POST['santanderCreditShopId']));
                Configuration::updateValue('SANTANDERCREDIT_BLOCK', $santanderCreditBlock);
                Configuration::updateValue('SANTANDERCREDIT_BLOCK_TITLE', $santanderCreditBlockTitle);
                Configuration::updateValue('SANTANDERCREDIT_SYMULATOR', $santanderCreditSymulator);
                Configuration::updateValue('SANTANDERCREDIT_SYMULATOR', $santanderCreditSymulator);
//                SANTANDERCREDIT_USE_ORDER_STATE
                Configuration::updateValue('SANTANDERCREDIT_USE_ORDER_STATE', $santanderCreditUseOrderState);                
                $this->displayConf();
            } else {

                $this->displayErrors();
            }
        }

        $this->displayInformation();
        $this->displayFormSettings();

        return $this->_html;
    }

    public function displayConf() {

        $this->_html .= '
	<div class="conf confirm">
		<img src="../img/admin/ok.gif" />
		' . $this->l('Ustawienia zostały zapisane') . '
	</div>
  ';
    }

    public function displayErrors() {

        $this->_html .= '
	<div class="alert error">
		<h3>Wystąpiły błędy:</h3>
		<ol>
	';

        foreach ($this->_errorsArray as $error) {
            $this->_html .= '<li>' . $error . '</li>';
        }

        $this->_html .= '
	  </ol>
	</div>
	';
    }

    public function displayInformation() {

        $this->_html .= '
	<fieldset style="background: #fff; margin: 10px 0;">

	    <legend><img src="../img/admin/details.gif" />' . $this->l('Informacje') . '</legend>

	    <p>
	        <img src="../modules/' . $this->name . '/images/moduleLogo.jpg" />
	    </p>

	    <p>
	        <b>' . $this->l('Moduł umożliwia sprzedaż ratalną za pomocą systemu Santander Consumer Bank') . '</b>
	    </p>

	    <p>
	        ' . $this->l('Przed użyciem modułu skonfiguruj swoje ustawienia dla Santander za pomocą opcji dostępnych poniżej.') . '
	    </p>

	</fieldset>
	';
    }

    public function displayFormSettings() {

//        global $cookie;
        //$currentLangId = Context::getContext()->language->id;
//        $currentLangId = (int)($cookie->id_lang);
//        $santanderCreditUseOrderState = Configuration::get('SANTANDERCREDIT_USE_ORDER_STATE');
        
        $this->_html .= '
	<style type="text/css">
	form.prestahome * {
		text-align: left;
	}
	form.prestahome dl {
		float: left;
		margin: 10px 0;
	}
	form.prestahome dt label {
		width: 500px; float: left; clear: both; margin: 0;
	}
	form.prestahome dd {
		float: left; clear: both; margin: 5px 0;
	}
	form.prestahome .button {
		float: left; clear: both; cursor: pointer; overflow: hidden;
	}
	form.prestahome input[type=text] {
		min-width: 200px; padding: 5px;
	}
	</style>
	';


        $santanderCreditShopId = Configuration::get('SANTANDERCREDIT_SHOP_ID');
        $santanderCreditBlock = Configuration::get('SANTANDERCREDIT_BLOCK');
        $santanderCreditBlockTitle = Configuration::get('SANTANDERCREDIT_BLOCK_TITLE');
        $santanderCreditSymulator = Configuration::get('SANTANDERCREDIT_SYMULATOR');

//        $santandercreditOsAuthName = 'SANTANDERCREDIT_OS_AUTHORIZATION';
//        $santandercreditOsAuthNameObj = (new OrderState(Configuration::get('SANTANDERCREDIT_OS_AUTHORIZATION')));
//        if ($santandercreditOsAuthNameObj != null) {
//            $santandercreditOsAuthName = $santandercreditOsAuthNameObj->name[$currentLangId];
//        }

//        $psOsPaymentName = 'PS_OS_PAYMENT';
//        $psOsPaymentNameObj = (new OrderState(Configuration::get('PS_OS_PAYMENT')));
//        if ($psOsPaymentNameObj != null) {
//            $psOsPaymentName = $psOsPaymentNameObj->name[$currentLangId];
//        }

        $this->_html .= '
	<style>
	#santanderCreditBox {
	    float: left;
	    line-height: 25px;
	    text-align: center;
	}
	#santanderCreditBox div {
	  text-align: center;
	  float: left;
	  border: 1px solid #CCCED7;
	  border-radius: 5px;
	  padding: 5px;
	  margin: 0 20px 20px 0;
	}
	#santanderCreditBox label {
	  float: none;
	  cursor: pointer;
	  width: auto;
	  font-weight: normal;
	}
	</style>
	<div id="santanderCreditBox">
	<form action="' . $_SERVER['REQUEST_URI'] . '" method="post" class="prestahome">
	<fieldset>
	<legend><img src="../img/admin/contact.gif" />' . $this->l('Ustawienia') . '</legend>

	  <div style="margin: 20px auto; float: none;">
			' . $this->l('Twój numer sklepu to numer Punktu Sprzedaży wskazany przez Santander Consumer Bank w „Umowie o współpracy – tryb Internet”') . '
			<br>
			<input type="text" name="santanderCreditShopId" style="width: 80px; min-width: auto;" value="' . $santanderCreditShopId . '" />
	  ';

        if ($santanderCreditShopId == $this->shopTestId) {
            $this->_html .= '<br clear="all"><div class="warning" style="margin: 10px 0 0 0; float: none;">Uwaga! Używasz testowego numeru sklepu. <br>Służy on tylko i wyłącznie do testowania płatności ratalnej!</div>';
        }
        $this->_html .= '</div>';

        /*SANTANDERCREDIT_OS_AUTHORIZATION*/
/*        
        $this->_html .= '<br clear="all"><div style="width:100%">
                Status zamówienia do czasu uzyskania decyzji kredytowej:
                <br>
                <label for="leftColumn">
                    <input id="leftColumn" type="radio" name="santanderCreditUseOrderState" value="PS_OS_PAYMENT" ';
        if($santanderCreditUseOrderState == 'PS_OS_PAYMENT') {
            $this->_html .= ' checked="checked"';
        }
        $this->_html .= '> '.$psOsPaymentName.'
                </label>
                &nbsp;&nbsp;
                <label for="rightColumn">
                    <input id="rightColumn" type="radio" name="santanderCreditUseOrderState" value="SANTANDERCREDIT_OS_AUTHORIZATION" ';
        if($santanderCreditUseOrderState == 'SANTANDERCREDIT_OS_AUTHORIZATION') {
            $this->_html .= ' checked="checked"';
        }
        $this->_html .= '> '.$santandercreditOsAuthName.'
                </label>
            </div>            
        ';
  */      
        /*SANTANDERCREDIT_OS_AUTHORIZATION end*/
        
        $this->_html .= '
	  <br clear="all">

		<div>
			' . $this->l('W której kolumnie wyświetlić banner Raty Santander?') . '
			<br>
			<label for="leftColumn"><input id="leftColumn" type="radio" name="santanderCreditBlock" value="left" ' . ( $santanderCreditBlock == 'left' ? 'checked="checked"' : '' ) . '> Lewej</label>
			&nbsp;&nbsp;
			<label for="rightColumn"><input id="rightColumn" type="radio" name="santanderCreditBlock" value="right"  ' . ( $santanderCreditBlock == 'right' ? 'checked="checked"' : '' ) . '> Prawej</label>
		</div>

		<div>
			' . $this->l('Nagłówek bloku eRaty') . '
			<br>
			<input type="text" name="santanderCreditBlockTitle" style="width: 200px; min-width: auto;" value="' . $santanderCreditBlockTitle . '" />
		</div>

	  <div>
		  ' . $this->l('Czy wyświetlić ikonę &quot;Oblicz Ratę&quot; na stronie produktu?') . '
		  <br>
			<label for="santanderCreditSymulatorTak"><input id="santanderCreditSymulatorTak" type="radio" name="santanderCreditSymulator" value="tak"  ' . ( $santanderCreditSymulator == 'tak' ? 'checked="checked"' : '' ) . '> Tak</label>
			&nbsp;&nbsp;
			<label for="santanderCreditSymulatorNie"><input id="santanderCreditSymulatorNie" type="radio" name="santanderCreditSymulator" value="nie" ' . ( $santanderCreditSymulator == 'nie' ? 'checked="checked"' : '' ) . '> Nie</label>
	  </div>

	  <br clear="all">

    <div style="margin: 20px auto; float: none;">
			    Jeśli chcesz zmienić banner wyświetlany w kolumnach, zmień plik "bannerBlok.jpg" w katalogu "/modules/' . $this->name . '/images/".
			    <br>
			    <img src="http://' . $_SERVER['HTTP_HOST'] . __PS_BASE_URI__ . '/modules/' . $this->name . '/images/bannerBlok.jpg">
	  </div>

		<input type="submit" name="santanderCreditSubmit" value="' . $this->l('Zapisz') . '" class="button" />
	</fieldset>
	</form>
  </div>
	';
    }

    public function hookPayment($params) {

        global $smarty;

        $smarty->assign(array(
            'totalOrder' => $params['cart']->getOrderTotal(),
            'shopId' => Configuration::get('SANTANDERCREDIT_SHOP_ID')
        ));

        return $this->display(__FILE__, 'santanderCredit.tpl');
    }

    public function hookShoppingCart($params) {

        global $smarty;

        $smarty->assign(array(
            'totalOrder' => $params['cart']->getOrderTotal(),
            'shopId' => Configuration::get('SANTANDERCREDIT_SHOP_ID')
        ));

        return $this->display(__FILE__, 'santanderCreditCart.tpl');
    }

    public function execValidation() {
        global $cart, $currency;
        $total = floatval(number_format($cart->getOrderTotal(true, 3), 2, '.', ''));
//      may be PS_OS_PAYMENT  or SANTANDERCREDIT_OS_AUTHORIZATION
        $useOrderState = Configuration::get('SANTANDERCREDIT_USE_ORDER_STATE');
        $this->validateOrder($cart->id, (int) Configuration::get($useOrderState), $total, $this->displayName, NULL, NULL, $currency->id);        
//        $this->validateOrder($cart->id, (int) Configuration::get('PS_OS_PAYMENT'), $total, $this->displayName, NULL, NULL, $currency->id);
        return $this->currentOrder;
    }

    public function execPayment() {

        global $smarty, $cookie, $cart, $currency;

        $address = new Address(intval($cart->id_address_invoice));
        $customer = new Customer(intval($cart->id_customer));

        $total = floatval(number_format($cart->getOrderTotal(true, 3), 2, '.', ''));

        //$this->validateOrder($cart->id, (int)Configuration::get('PS_OS_PAYMENT'), $total, $this->displayName, NULL, NULL, $currency->id);

        $santanderCreditShopId = Configuration::get('SANTANDERCREDIT_SHOP_ID');


        if (!Validate::isUnsignedInt($santanderCreditShopId)) {
            return $this->l('Błąd płatności: nieprawidłowy numer eRaty sklepu.');
        }

        if (!Validate::isLoadedObject($address) || !Validate::isLoadedObject($customer)) {
            return $this->l('Błąd płatności: nieprawidłowy adres lub dane klienta.');
        }


        $productsInputs = '';
        $products = $cart->getProducts(true);
        $summaryDetails = $cart->getSummaryDetails();

        for ($i = 0, $nr = 1; $i < sizeof($products); $i++, $nr++) {

            $productsInputs .= '
			<input name="idTowaru' . $nr . '" readonly="readonly" type="hidden" value="' . $products[$i]['id_product'] . '" />
			<input name="nazwaTowaru' . $nr . '" readonly="readonly" type="hidden" value="' . $products[$i]['name'] . '" />
			<input name="wartoscTowaru' . $nr . '" readonly="readonly" type="hidden" value="' . $products[$i]['price_wt'] . '" />
			<input name="liczbaSztukTowaru' . $nr . '" readonly="readonly" type="hidden" value="' . $products[$i]['quantity'] . '" />
			<input name="jednostkaTowaru' . $nr . '" readonly="readonly" type="hidden" value="szt" />
		';
        }

        if ($summaryDetails['total_shipping'] > 0) {

            $productsInputs .= '
  		<input type="hidden" name="idTowaru' . $nr . '" readonly="readonly" value="KosztPrzesylki" />
  		<input type="hidden" name="nazwaTowaru' . $nr . '" readonly="readonly" value="Koszt przesyłki" />
  		<input type="hidden" name="wartoscTowaru' . $nr . '" readonly="readonly" value="' . round($summaryDetails['total_shipping'], 2) . '" />
  	  <input type="hidden" name="liczbaSztukTowaru' . $nr . '" readonly="readonly" value="1" />
      <input type="hidden" name="jednostkaTowaru' . $nr . '" readonly="readonly" value="szt" />
    ';
        }

        $productsInputs .= '
	  <input type="hidden" name="liczbaSztukTowarow" value="' . $nr . '" />
	';



        $smarty->assign(array(
            'orderId' => intval($this->currentOrder),
            'shopId' => $santanderCreditShopId,
            'shopName' => Configuration::get('PS_SHOP_NAME'),
            'shopMailAdress' => Configuration::get('PS_SHOP_EMAIL'),
            'shopPhone' => Configuration::get('PS_SHOP_PHONE'),
            'shopHttp' => 'http://' . $_SERVER['HTTP_HOST'] . __PS_BASE_URI__,
            'returnTrue' => 'http://' . $_SERVER['HTTP_HOST'] . __PS_BASE_URI__ . 'modules/' . $this->name . '/santanderCreditReturn.php?status=true&orderId=',
            'returnFalse' => 'http://' . $_SERVER['HTTP_HOST'] . __PS_BASE_URI__ . 'modules/' . $this->name . '/santanderCreditReturn.php?status=false&orderId=',
            'email' => $customer->email,
            'imie' => ( $cookie->logged ? $cookie->customer_firstname : false ),
            'nazwisko' => ( $cookie->logged ? $cookie->customer_lastname : false ),
            'telKontakt' => $address->phone_mobile,
            'ulica' => $address->address1,
            'ulica2' => $address->address2,
            'miasto' => $address->city,
            'kodPocz' => $address->postcode,
            'productsInputs' => $productsInputs
        ));

        return $this->display(__FILE__, 'santanderCreditForm.tpl');
    }

    function paymentReturn() {

        global $smarty;

        $status = Tools::getValue('status');
        $wniosekId = Tools::getValue('wniosekId');

        $smarty->assign(array(
            'status' => $status,
            'wniosekId' => $wniosekId
        ));

        return $this->display(__FILE__, 'santanderCreditReturn.tpl');
    }

    function hookLeftColumn() {

        global $smarty;

        $smarty->assign(array(
            'santanderCreditBlockTitle' => Configuration::get('SANTANDERCREDIT_BLOCK_TITLE')
        ));

        if (Configuration::get('SANTANDERCREDIT_BLOCK') == 'left') {
            return $this->display(__FILE__, 'santanderCreditBlock.tpl');
        }
    }

    function hookRightColumn() {

        global $smarty;

        $smarty->assign(array(
            'santanderCreditBlockTitle' => Configuration::get('SANTANDERCREDIT_BLOCK_TITLE')
        ));

        if (Configuration::get('SANTANDERCREDIT_BLOCK') == 'right') {
            return $this->display(__FILE__, 'santanderCreditBlock.tpl');
        }
    }

    function hookProductActions() {

        global $smarty;

        $id_product = Tools::getValue('id_product');
        $product = new Product($id_product, true);

        $smarty->assign(array(
            'shopId' => Configuration::get('SANTANDERCREDIT_SHOP_ID'),
            'santanderCreditProductPrice' => round($product->getPrice(true), 2)
        ));

        if (Configuration::get('SANTANDERCREDIT_SYMULATOR') == 'tak') {
            return $this->display(__FILE__, 'santanderCreditProduct.tpl');
        }
    }

    /**
     * Creates new order state for eRaty payment system and configuration parameter SANTANDERCREDIT_OS_AUTHORIZATION
     * containing new order id. If parameter already exists - do nothing.
     * 
     * @boolean creating order result
     */
    function createOrderState() {
        $result = true;
        if (!Configuration::get('SANTANDERCREDIT_OS_AUTHORIZATION')) {
            try {
                $order_state = new OrderState();
                $order_state = new OrderState();
                $order_state->name = array();

                foreach (Language::getLanguages() as $language) {
                    if (Tools::strtolower($language['iso_code']) == 'pl')
                        $order_state->name[$language['id_lang']] = 'Płatność eRaty – status decyzji Banku dostępny w Panel Sklep.';
                    else
                        $order_state->name[$language['id_lang']] = 'eRaty payment - decision state available in Panel Sklep.';
                }

                $order_state->send_email = false;
                $order_state->color = '#DDEEFF';
                $order_state->hidden = false;
                $order_state->delivery = false;
                $order_state->logable = true;
                $order_state->invoice = true;
                //w wersji 1.4 nie ma tego pola
                //$order_state->module_name = 'eRaty';

                $order_state->add();
                $result = Configuration::updateValue('SANTANDERCREDIT_OS_AUTHORIZATION', (int) $order_state->id);
            } catch (Exception $exc) {
                $result = false;
            }
        }
        return $result;
    }

}

?>