<?php

include_once(dirname(__FILE__).'/../../config/config.inc.php');
include_once(dirname(__FILE__).'/../../header.php');
include_once(dirname(__FILE__).'/santandercredit.php');

$santanderCredit = new SantanderCredit();


if ( Tools::getValue('orderId') != 0 && Tools::getValue('wniosekId') != '') {

	$cart = new Cart(Tools::getValue('orderId'));

	$errors = '';

	if ( !$cart->id ) {
	  $errors .= '<p>Błąd koszyka (ID).</p>';
	}

	if ( Order::getOrderByCartId( Tools::getValue('orderId') ) ) {
	  $errors .= '<p>Błąd zamówienia. Zamówienia o podanym numerze już istnieje.</p>';
	}


	if ( $errors == '' ) {

		if (
		    $santanderCredit->validateOrder(
		        intval($cart->id),
		        _PS_OS_PAYMENT_,
		        floatval($cart->getOrderTotal()),
		        $santanderCredit->displayName
		        )
		    ) {

			$smarty->assign(array('HOOK_PAYMENT_RETURN' => $santanderCredit->paymentReturn()));

		}

	} else {

		$smarty->assign(array('HOOK_PAYMENT_RETURN' => $errors));

	}

}




if ( Tools::getValue('status') == 'false' ) {

	$smarty->assign(array('HOOK_PAYMENT_RETURN' => $santanderCredit->paymentReturn()));

}


$smarty->assign(
								array ('wniosekId'=> preg_replace('#[^0-9/ZAG]#', '', $_GET['id_wniosku']),
								'orderId'=> (int)$_GET['orderId']
								)
								);

$smarty->display($module_dir.'santanderCreditReturn.tpl');

include_once('../../footer.php');

?>