<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

add_action( 'plugins_loaded', 'wc_gateway_eraty_init', 0 );

function wc_gateway_eraty_init()
{

    if (!class_exists('WC_Payment_Gateway')) {
        return;
    }

    class WC_Gateway_Eraty extends WC_Payment_Gateway
    {
        public function __construct()
        {
            $this->id = 'eraty';
            $this->api_url = ERATY__FORM_URL;
            $this->icon = ERATY__PLUGIN_URL . '/images/buy.png';
            $this->has_fields = true;

            $this->init_form_fields();
            $this->init_settings();

            $this->title = $this->get_option('title') ?: 'eRaty Santander Consumer Bank';

            add_action( 'woocommerce_update_options_payment_gateways_' . $this->id, array( $this, 'process_admin_options' ) );
            add_action( 'woocommerce_api_wc_gateway_' . $this->id, array( $this, 'check_eraty_response' ) );
        }

        public function payment_fields()
        {
            global $woocommerce;
            $total = $woocommerce->cart->total;

            ?>
            <p>Kup na raty z Santander Consumer Bank</p>
            <p>Przed złożeniem wniosku możesz zapoznać się z procedurą udzielenia kredytu ratalnego oraz obliczyć raty.</p>
            <p class="eraty-confirmation-buttons">
                <?php render_terms_button(); ?>
                <?php render_evaluate_button($total); ?>
            </p>
            <p>
                <input type="checkbox" id="<?php echo esc_attr( $this->id ) . '-confirmation' ?>" name="<?php echo esc_attr( $this->id ) . '-confirmation' ?>" />
                Zapoznałem się <a href="#" class="eraty-terms-button">z procedurą udzielenia kredytu konsumenckiego na zakup towarów i usług eRaty Santander Consumer Bank</u></a>
            </p>
            <p>Aby rozpocząć proces składania wniosku ratalnego należy zapoznać się z procedurą udzielenia kredytu, a następnie kliknąć na przycisk składania zamówienia.</p>
            <?php
        }

        public function validate_fields()
        {
            if ($this->get_post_value($this->id . '-confirmation') != 'on') {
                wc_add_notice(__('Aby kontynuować proces zakupów na raty, należy potwierdzić fakt zapoznania się z procedurą udzielania kredytu konsumenckiego na zakup towarów i usług eRaty Santander Consumer Bank', 'eraty'), 'error');
                return false;
            }

            return true;
        }

        public function init_form_fields() {
            $this->form_fields = array(
                'enabled' => array(
                    'title' => __( 'Włącz/Wyłącz', 'eraty' ),
                    'type' => 'checkbox',
                    'label' => __( 'Włącz system eRaty', 'eraty' ),
                    'default' => 'yes'
                ),
                'title' => array(
                    'title'   => __( 'Tytuł', 'eraty' ),
                    'type'    => 'text',
                    'default' => 'eRaty Santander Consumer Bank'
                ),
            );
        }

        public function init_settings() {
            parent::init_settings();

            global $woocommerce;

            $this->enabled  = (!empty($this->settings['enabled']) && 'yes' === $this->settings['enabled'] && $woocommerce->cart->total > ERATY__MIN_AMOUNT) ? 'yes' : 'no';
        }

        private function get_post_value($key) {
            return isset($_POST[$key]) ? $_POST[$key] : null;
        }

        private function format_price($value) {
            return number_format($value, 2, '.', '');
        }

        public function process_payment($order_id) {
            global $woocommerce;

            $order = new WC_Order($order_id);
            $total = $this->format_price($woocommerce->cart->total);

            $items = $woocommerce->cart->get_cart();

            $params = array(
                'wartoscTowarow' => $total,
                'liczbaSztukTowarow' => count($items),
                'numerSklepu' => get_option('eraty_shop_id'),
                'typProduktu' => '0',
                'nrZamowieniaSklep' => $order_id,
                'sposobDostarczeniaTowaru' => 'Przesyłka',

                'pesel' => null,
                'imie' => $this->get_post_value('billing_first_name'),
                'nazwisko' => $this->get_post_value('billing_last_name'),
                'email' => $this->get_post_value('billing_email'),
                'telKontakt' => $this->get_post_value('billing_phone'),
                'ulica' => $this->get_post_value('billing_address_1'),
                'nrDomu' => $this->get_post_value('billing_address_2'),
                'nrMieszkania' => null,
                'miasto' => $this->get_post_value('billing_city'),
                'kodPocz' => $this->get_post_value('billing_postcode'),

                'char' => 'ISO',
                'wniosekZapisany' => str_replace( 'https:', 'http:', add_query_arg(array(
                        'wc-api' => 'WC_Gateway_Eraty',
                        'status' => 'saved',
                        'order_id' => $order_id,
                        'application_id' => ''
                    ), home_url( '/' ) ) ) . '=',
                'wniosekAnulowany' => str_replace( 'https:', 'http:', add_query_arg(array(
                        'wc-api' => 'WC_Gateway_Eraty',
                        'status' => 'cancelled',
                        'order_id' => $order_id,
                        'application_id' => ''
                    ), home_url( '/' ) ) ) . '=',
            );

            $productsTotal = 0;
            $nr = 0;
            foreach($items as $item) {
                $nr++;

                $params['idTowaru' . $nr] = $item['product_id'];
                $params['nazwaTowaru' . $nr] = $item['data']->post->post_title;
                $params['liczbaSztukTowaru' . $nr] = $item['quantity'];
                $params['wartoscTowaru' . $nr] = $this->format_price($item['data']->price);
                $params['jednostkaTowaru' . $nr] = 'sztuki';

                $productsTotal += $item['data']->price * $item['quantity'];
            }

            if ($shipping = $order->get_total_shipping())
            {
                $nr++;
                $params['idTowaru' . $nr] = 'KosztPrzesylki';
                $params['nazwaTowaru' . $nr] = 'Koszt przesylki';
                $params['liczbaSztukTowaru' . $nr] = 1;
                $params['wartoscTowaru' . $nr] = $shipping;
                $params['jednostkaTowaru' . $nr] = 'sztuki';

                $productsTotal += $shipping;
            }

            if (($discount = $productsTotal - $woocommerce->cart->total) != 0)
            {
                $nr++;
                $params['idTowaru' . $nr] = 'NaliczoneRabaty';
                $params['nazwaTowaru' . $nr] = 'Naliczone rabaty';
                $params['liczbaSztukTowaru' . $nr] = 1;
                $params['wartoscTowaru' . $nr] = -$discount;
                $params['jednostkaTowaru' . $nr] = 'sztuki';
            }

            return array(
                'result' => 'success',
                'redirect' => $this->api_url,
                'eraty_params' => $params
            );
        }

        function check_eraty_response() {
            $status = $_GET['status'] ?: 'cancelled';
            $applicationId = $_GET['application_id'];

            $return_button = '<p><a href="' . esc_url( wc_get_page_permalink( 'shop' ) ) . '" class="button">' . __('Wróć do sklepu', 'eraty') . '</a></p>';

            if ($status == 'saved'){
                wp_die('<b>Dziękujemy za złożenie wniosku. </b>' .
                    '<br><br>Numer wniosku kredytowego/decyzja to: <b>' . $applicationId . '</b>.' .
                    '<br><br><b>W przypadku pozytywnej wstępnej weryfikacji oczekuj na kontakt telefoniczny z konsultantem Santander Consumer Bank</b>' .
                    '<br><br>Podczas rozmowy telefonicznej sporządzi razem z Tobą umowę ratalną.' .
                    '<br><br>Przygotuj: dowód osobisty oraz drugi dokument tożsamości.' .
                    $return_button
                );
            } else {
                wp_die('Zrezygnowałeż z otrzymania kredytu ratalnego.' .
                    '<br>Skontaktuj się z właścicielem sklepu w celu wyjaśnienia sytuacji oraz pomyślnym dokończenia transakcji.' .
                    $return_button
                );
            }
        }
    }

    function add_eraty_gateway_class( $methods ) {
        $methods[] = 'WC_Gateway_Eraty';
        return $methods;
    }

    add_filter( 'woocommerce_payment_gateways', 'add_eraty_gateway_class' );
}