jQuery(document).ready(function($){
    function encodeParameters(parameters) {
        var result = '';

        for(var parameterName in parameters) {
            result += '/' + parameterName + '/' + parameters[parameterName];
        }

        return result;
    }

    $('body').on('click', '.eraty-evaluate-button', function() {
        var value = $(this).data('eratyValue');
        var url = data.evaluate_url + encodeParameters({
                'numerSklepu': data.shop_id,
                'typProduktu': 0,
                'wartoscTowarow': value
            });

        window.open(url, 'eraty_evaluate', 'width=640,height=500,directories=no,location=no,menubar=no,resizable=yes,scrollbars=yes,status=no,toolbar=no');
    });

    $('body').on('click', '.eraty-terms-button', function(){
        window.open('https://www.santanderconsumer.pl/raty-jak-kupic', 'eraty_how', 'width=600,height=500,directories=no,location=no,menubar=no,resizable=yes,scrollbars=yes,status=no,toolbar=no');
        return false;
    });

    var oldAjax = $.ajax;

    $.ajax = function(params){
        if (!params || typeof(wc_checkout_params) == 'undefined' || params.url != wc_checkout_params.checkout_url)
            return oldAjax(params);

        var successAction = params.success;

        params.success = function(result){
            try {
                if (result.result === 'success' && result.eraty_params) {
                    var $form = $('<form/>', {
                        method: 'POST',
                        action: result.redirect
                    });

                    for(var paramName in result.eraty_params) {
                        $form.append($('<input>', {
                            type: 'hidden',
                            name: paramName,
                            value: result.eraty_params[paramName]
                        }));
                    }

                    $form.submit();
                } else {
                    successAction(result);
                }
            } catch( err ) {
                wc_checkout_form.submit_error( '<div class="woocommerce-error">' + wc_checkout_params.i18n_checkout_error + '</div>' );
            }
        };

        return oldAjax(params);
    }
});
