<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

add_action( 'admin_menu', 'eraty_admin_menu' );

function eraty_admin_menu() {
    add_options_page( __('Ustawienia eRaty', 'eraty'), __('eRaty', 'eraty'), 'manage_options', 'eraty-settings', 'eraty_settings_page' );
}

function eraty_settings_page() {
    if ( !current_user_can( 'manage_options' ) )  {
        wp_die( __( 'You do not have sufficient permissions to access this page.' ) );
    }

    $opt_name = 'eraty_shop_id';
    $hidden_field_name = 'eraty_submit_hidden';
    $data_field_name = 'eraty_shop_id';

    $opt_val = get_option( $opt_name );

    if( isset($_POST[ $hidden_field_name ]) && $_POST[ $hidden_field_name ] == 'Y' ) {
        $opt_val = $_POST[ $data_field_name ];

        update_option( $opt_name, $opt_val );

        ?>
        <div class="updated"><p><strong><?php _e('Zmiany zapisane', 'eraty' ); ?></strong></p></div>
        <?php
    }
    ?>

    <div class="wrap">

    <h2><?php __( 'Ustawienia eRaty', 'eraty' ); ?></h2>

    <form name="form1" method="post" action="">
        <input type="hidden" name="<?php echo $hidden_field_name; ?>" value="Y">

        <p><?php _e("Numer sklepu", 'eraty' ); ?>
            <input type="text" name="<?php echo $data_field_name; ?>" value="<?php echo $opt_val; ?>" size="20">
        </p><hr />

        <p class="submit">
            <input type="submit" name="Submit" class="button-primary" value="<?php esc_attr_e('Zapisz zmiany') ?>" />
        </p>

    </form>
    </div>

    <?php
}