<?php
/**
 * Plugin Name: eRaty
 * Description: eRaty system integration for WooCommerce
 * Version: 1.2.10
 * Author: I&B
 * WC requires at least: 7.5
 */

use Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType;
use Automattic\WooCommerce\Blocks\Payments\PaymentMethodRegistry;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

define('ERATY__PLUGIN_DIR', plugin_dir_path( __FILE__ ));
define('ERATY__PLUGIN_URL', plugins_url('',  __FILE__ ));
define('ERATY__EVALUATE_URL', 'https://wniosek.eraty.pl/symulator/oblicz');
define('ERATY__FORM_URL', 'https://wniosek.eraty.pl/formularz');
define('ERATY__MIN_AMOUNT', 100);


function issetShopId(){
    return !empty(get_option( 'eraty_shop_id' )) && strlen(get_option( 'eraty_shop_id' )) > 3;
}

function priceIsValidated($price){
    $minPrice = !empty(get_option( 'eraty_min_price')) ? get_option( 'eraty_min_price') : ERATY__MIN_AMOUNT;
    $maxPrice = !empty(get_option( 'eraty_max_price')) && get_option( 'eraty_max_price') > ERATY__MIN_AMOUNT  ? get_option( 'eraty_max_price') : null;
    $minPriceIsValidated = $price > $minPrice;
    $maxPriceIsValidated = $maxPrice ? $price < $maxPrice : true;

    return $minPriceIsValidated && $maxPriceIsValidated && issetShopId();
}

if(!issetShopId()){
    function eraty_shop_id_required_alert(){
        echo '<div class="error"><p>';
        _e("Wtyczka <strong>eRaty</strong> nie została skonfigurowana. Przejdź do ustawień i dodaj numer sklepu.", 'eraty' );
        echo '</p></div>';
    }
    add_action('admin_notices', 'eraty_shop_id_required_alert');
}

if (!in_array('woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ))) && !in_array('woocommerce/woocommerce.php', array_keys(get_network_option(null, 'active_sitewide_plugins' ) ?: []))){
    function eraty_woocommerce_required_alert(){
        echo '<div class="error"><p>';
        _e("Wtyczka <strong>eRaty</strong> nie może działać bez aktywacji <strong>WooCommerce</strong>. Zainstaluj i aktywuj wtyczkę WooCommerce.", 'eraty' );
        echo '</p></div>';
    }
    add_action('admin_notices', 'eraty_woocommerce_required_alert');
}else{
    require_once( ERATY__PLUGIN_DIR . 'inc/eraty-schedule.php' );
    require_once( ERATY__PLUGIN_DIR . 'inc/eraty-admin.php' );
    require_once( ERATY__PLUGIN_DIR . 'inc/eraty-front.php' );
    require_once( ERATY__PLUGIN_DIR . 'inc/wc-gateway-eraty.php' );
}

/**
 * Custom function to declare compatibility with cart_checkout_blocks feature
 */
function declare_cart_checkout_blocks_compatibility () {
    if (class_exists(FeaturesUtil::class)) {
       FeaturesUtil::declare_compatibility(
            'cart_checkout_blocks',
            __FILE__,
            true
        );
    }
}

add_action('before_woocommerce_init', 'declare_cart_checkout_blocks_compatibility');

function eraty_block_gateway_block_support() {
    if ( class_exists(AbstractPaymentMethodType::class) ) {
        require_once plugin_dir_path(__FILE__) . '/inc/wc-getaway-blocks-eraty.php';

        add_action(
            'woocommerce_blocks_payment_method_type_registration',
            function( PaymentMethodRegistry $payment_method_registry ) {
                $payment_method_registry->register( new WC_Gateway_Blocks_Eraty );
            }
        );
    }
}

add_action( 'woocommerce_blocks_loaded', 'eraty_block_gateway_block_support');
