<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

add_action( 'admin_menu', 'eraty_admin_menu', 99 );

function eraty_admin_menu() {
    add_submenu_page( 'woocommerce', __('Ustawienia eRaty', 'eraty'), __('eRaty', 'eraty'), 'manage_woocommerce', 'eraty-settings', 'eraty_settings_page' );
}

function eraty_settings_page() {
    if ( !current_user_can( 'manage_woocommerce' ) )  {
        wp_die( __( 'You do not have sufficient permissions to access this page.' ) );
    }
    $currency = !empty(get_option('woocommerce_currency')) ? get_option('woocommerce_currency') : '';
    $shop_id_name = 'eraty_shop_id';
    $webservice_login_name = 'eraty_webservice_login';
    $webservice_password_name = 'eraty_webservice_password';
    $shop_cert_password_name = 'eraty_shop_cert';
    $shop_cert_file_field_name = 'eraty_shop_cert_file_name';
    $min_price_name = 'eraty_min_price';
    $max_price_name = 'eraty_max_price';
    $hidden_field_name = 'eraty_submit_hidden';

    $shop_id = get_option( $shop_id_name );
    $webservice_login = get_option( $webservice_login_name );
    $webservice_password = get_option( $webservice_password_name );
    $shop_cert_password = get_option( $shop_cert_password_name );
    $min_price = !empty(get_option( $min_price_name)) ? get_option( $min_price_name) : ERATY__MIN_AMOUNT;
    $max_price = get_option( $max_price_name );
    $shop_cert_file_name = get_option( $shop_cert_file_field_name );

    if( isset($_POST[ $hidden_field_name ]) && $_POST[ $hidden_field_name ] == 'Y' ) {
        $shop_id = $_POST[ $shop_id_name ];
        $webservice_login = $_POST[ $webservice_login_name ];
        $webservice_password = $_POST[ $webservice_password_name ];
        $shop_cert_password = $_POST[ $shop_cert_password_name ];
        $min_price = format_price(isset($_POST[ $min_price_name ]) && $_POST[ $min_price_name ] >= ERATY__MIN_AMOUNT ? $_POST[ $min_price_name ] : ERATY__MIN_AMOUNT);
        $max_price = format_price($_POST[ $max_price_name ]);

        update_option( $shop_id_name, $shop_id );
        update_option( $webservice_login_name, $webservice_login );
        update_option( $webservice_password_name, $webservice_password );
        update_option( $shop_cert_password_name, $shop_cert_password );
        update_option( $min_price_name, $min_price);
        if($max_price && !empty($max_price) && $max_price > $min_price){
            update_option( $max_price_name, $max_price);
        }else{
            delete_option( $max_price_name );
        }

        if($_FILES["eraty_shop_cert_file"]["tmp_name"] ?? null){
            $file_name = $_FILES["eraty_shop_cert_file"]["name"];
            $ext = pathinfo($file_name, PATHINFO_EXTENSION);
            if($ext != 'p12'){
                ?>
                <div class="error"><p><strong><?php _e('Plik certyfikatu ma nieodpowiednie rozszerzenie - wymagane rozszerzenie to p12', 'eraty' ); ?></strong></p></div>
                <?php
            }else{
                move_uploaded_file($_FILES["eraty_shop_cert_file"]["tmp_name"], WP_CONTENT_DIR . '/'.$file_name);
                update_option( $shop_cert_file_field_name, $file_name );
                $shop_cert_file_name = $file_name;
            }

        }
        ?>
        <div class="updated"><p><strong><?php _e('Zmiany zapisane', 'eraty' ); ?></strong></p></div>
        <?php
    }
    ?>

    <div class="wrap">

        <h2><?php echo __( 'Ustawienia eRaty', 'eraty' ); ?></h2>

        <form name="form1" method="post" action="" enctype="multipart/form-data">
            <input type="hidden" name="<?php echo $hidden_field_name; ?>" value="Y">

            <p><?php _e("Numer sklepu (wymagane)", 'eraty' ); ?>
                <input type="number" name="<?php echo $shop_id_name; ?>" value="<?php echo $shop_id; ?>" size="30" required>
            </p>
            <p><?php _e("Webservice Login", 'eraty' ); ?>
                <input type="text" name="<?php echo $webservice_login_name; ?>" value="<?php echo $webservice_login; ?>" size="30">
            </p>
            <p><?php _e("Webservice hasło", 'eraty' ); ?>
                <input type="password" name="<?php echo $webservice_password_name; ?>" value="<?php echo $webservice_password; ?>" size="30">
            </p>
            <div>
                <?php _e("Plik certyfikatu (rozszerzenie .p12)", 'eraty' ); ?>
                <?php if($shop_cert_file_name ?? null) {?>
                    <div style="margin-top: 10px;">
                        Dodany plik: <?php echo $shop_cert_file_name; ?>
                    </div>
                <?php } ?>
                <div>
                    <input type="file" name="eraty_shop_cert_file" >
                </div>
            </div>
            <p>
                <?php _e("Hasło certyfikatu", 'eraty' ); ?>
                <input type="password" name="<?php echo $shop_cert_password_name; ?>" value="<?php echo $shop_cert_password; ?>" size="30">
            </p>
            <p>
                <?php _e("Minimalna kwota do zakupu z eRaty", 'eraty' ); ?>
                <input type="text" name="<?php echo $min_price_name; ?>" value="<?php echo $min_price; ?>" size="10"> <?php echo $currency; ?>
            </p>
            <p>
                <?php _e("Maksymalna kwota do zakupu z eRaty", 'eraty' ); ?>
                <input type="text" name="<?php echo $max_price_name; ?>" value="<?php echo $max_price; ?>" size="10"> <?php echo $currency; ?>
            </p>
            <hr />

            <p class="submit">
                <input type="submit" name="Submit" class="button-primary" value="<?php esc_attr_e('Zapisz zmiany') ?>" />
            </p>

        </form>
    </div>

    <?php
}

function eraty_aplication_id_in_order_details( $order ){
    if($order->get_meta('_eraty_application_id') ?? null){
        ?>
        <div class="order_data_column">
            <h4><?php _e("Numer wniosku eRaty", 'eraty' ); ?></h4>
            <?php
            echo '<p>' . $order->get_meta('_eraty_application_id') . '</p>';
            if($order->get_status() == 'on-hold'){
                ?>
                <a href="<?php echo esc_url( add_query_arg( 'eraty_status', 'check' ) )?>"><?php _e("Sprawdź decyzję", 'eraty' ); ?></a>
                <?php
                if(isset($_GET['eraty_status']) && $_GET['eraty_status'] == 'check'){
                    ?>
                    <p><?php _e("Nie ma jeszcze decyzji", 'eraty' ); ?></p>
                    <?php
                }
            }else if($order->get_status() == 'completed'){
                ?>
                <p><?php _e("Decyzja: Pozytywna", 'eraty' ); ?></p>
                <?php
            }else if($order->get_status() == 'cancelled'){
                ?>
                <p><?php _e("Decyzja: Negatywna", 'eraty' ); ?></p>
                <?php
            }else{
                ?>
                <p><?php _e("Decyzja: Wymaga weryfikacji w panelu", 'eraty' ); ?></p>
                <?php
            }
            ?>
        </div>
        <?php
    }
}
add_action( 'woocommerce_admin_order_data_after_billing_address', 'eraty_aplication_id_in_order_details', 10, 1 );

function check_application_status() {
    if(isset($_GET['eraty_status']) && $_GET['eraty_status'] == 'check'){
        do_action('eraty_hourly');
    }
}
add_action( 'admin_init', 'check_application_status' );

function format_price($value) {
    if(!is_numeric($value)){
        return null;
    }
    return number_format(preg_replace(['/,/', '/\s+/'], ['.', ''], $value), 2, '.', '');
}
