<?php

use Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType;

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

require_once plugin_dir_path(__FILE__) . '/wc-gateway-eraty.php';
require_once plugin_dir_path(__FILE__) . '/eraty-front.php';

final class WC_Gateway_Blocks_Eraty extends AbstractPaymentMethodType
{
    private $gateway;
    protected $name = 'eraty';

    public function initialize()
    {
        $this->settings = get_option( "woocommerce_{$this->name}_settings", []);
        $this->gateway = new WC_Gateway_Eraty(true);
    }

    public function is_active()
    {
        return $this->gateway->settings['enabled'];
    }

    public function get_payment_method_script_handles()
    {
        wp_register_script(
            'eraty-blocks-integration',
            plugin_dir_url(__FILE__) . 'checkout.js',
            [
                'wc-blocks-registry',
                'wc-settings',
                'wp-element',
                'wp-html-entities',
            ],
            null,
            false
        );

        return ['eraty-blocks-integration'];
    }


    public function get_payment_method_data()
    {
        global $woocommerce;
        $total = $woocommerce->cart->total;

        return [
            'title' => $this->get_setting('title'),
            'description' => $this->get_setting('description'),
            'evaluateImgURL' => ERATY__PLUGIN_URL . '/images/evaluate.png',
            'howImgURL' => ERATY__PLUGIN_URL . '/images/how.png',
            'cartValue' => $total
        ];
    }
}
