const settings = window.wc.wcSettings.getSetting('eraty_data', {});
const label = window.wp.htmlEntities.decodeEntities(settings.title);

const Content = (props) => {
    const [procedureCheckbox, setProcedureCheckbox] = React.useState(false);
    const {eventRegistration, emitResponse} = props;
    const {onPaymentProcessing} = eventRegistration;

    React.useEffect(() => {
        const unsubscribe = onPaymentProcessing(async () => {
            if (!procedureCheckbox) {
                return {
                    type: emitResponse.responseTypes.ERROR,
                    message: 'Aby kontynuować proces zakupów na raty, należy potwierdzić fakt zapoznania się z procedurą udzielania kredytu konsumenckiego na zakup towarów i usług eRaty Santander Consumer Bank',
                };
            }

            return {
                type: emitResponse.responseTypes.SUCCESS,
                meta: {
                    paymentMethodData: {
                        procedureCheckbox,
                    },
                },
            };
        });

        return () => {
            unsubscribe();
        };
    }, [
        emitResponse,
        onPaymentProcessing,
        procedureCheckbox,
    ]);

    const handleTermsChange = (event) => {
        setProcedureCheckbox(event.target.checked);
    };

    const label = React.createElement('p', null, 'Kup na raty z Santander Consumer Bank');
    const label2 = React.createElement('p', null, 'Przed złożeniem wniosku możesz zapoznać się z procedurą udzielenia kredytu ratalnego oraz obliczyć raty.');
    const label3 = React.createElement('p', null, 'Aby rozpocząć proces składania wniosku ratalnego należy zapoznać się z procedurą udzielenia kredytu, a następnie kliknąć na przycisk składania zamówienia.');
    const evaluateImage = React.createElement('img', {
        title: 'oblicz ratę',
        alt: 'oblicz ratę',
        src: settings.evaluateImgURL,
    })
    const howImage = React.createElement('img', {
        title: 'oblicz ratę',
        alt: 'oblicz ratę',
        src: settings.howImgURL,
    })
    const evaluateButton = React.createElement(
        'button', {
            className: 'eraty-image-button eraty-evaluate-button',
            ['data-eraty-value']: settings.cartValue
        }, evaluateImage
    )
    const howButton = React.createElement(
        'button', {className: 'eraty-image-button eraty-terms-button'},
        howImage)
    const buttons = React.createElement('p', {className: 'eraty-confirmation-buttons'}, evaluateButton, howButton);
    const checkbox = React.createElement('input', {
        type: 'checkbox',
        id: `${settings.id}-confirmation`,
        name: `${settings.id}-confirmation`,
        onChange: handleTermsChange
    });
    const checkboxLabelAnchor = React.createElement('a', {
        href: '#',
        className: 'eraty-terms-button'
    }, 'z procedurą udzielenia kredytu konsumenckiego na zakup towarów i usług eRaty Santander Consumer Bank')
    const checkboxContent = React.createElement('p', {className: 'eraty-confirmation-credit-rule'}, checkbox, 'Zapoznałem się ', checkboxLabelAnchor)

    return React.createElement('div', null, label, label2, buttons, checkboxContent, label3);
};

const Block_Gateway = {
    name: 'eraty',
    label: label,
    content: Object(window.wp.element.createElement)(Content, null),
    edit: Object(window.wp.element.createElement)(Content, null),
    canMakePayment: () => {
        return true;
    },
    ariaLabel: label,
    supports: {
        features: settings.supports,
    },
};

window.wc.wcBlocksRegistry.registerPaymentMethod(Block_Gateway);
