<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

add_filter('woocommerce_after_add_to_cart_button', 'eraty_product_evaluate_button');

function eraty_product_evaluate_button(){
    global $product;

    render_evaluate_button(wc_get_price_including_tax($product));
}

add_action('woocommerce_proceed_to_checkout', 'eraty_basket_evaluate_button');

function eraty_basket_evaluate_button() {
    global $woocommerce;

    render_evaluate_button($woocommerce->cart->total);
}

function render_evaluate_button($value){
    if (priceIsValidated($value)) {
        ?>

        <button type="button" class="eraty-image-button eraty-evaluate-button" data-eraty-value="<?php echo $value; ?>">
            <img src="<?php echo ERATY__PLUGIN_URL; ?>/images/evaluate.png" title="<?php echo __('Oblicz ratę', 'eraty'); ?>" alt="<?php echo __('Oblicz ratę', 'eraty'); ?>" border="0" />
        </button>

        <?php
    }
}

function render_terms_button(){
    ?>

    <button type="button" class="eraty-image-button eraty-terms-button">
        <img src="<?php echo ERATY__PLUGIN_URL; ?>/images/how.png" title="<?php echo __('Jak kupić', 'eraty'); ?>" alt="<?php echo __('Jak kupić', 'eraty'); ?>" border="0" />
    </button>

    <?php
}

add_action('wp_enqueue_scripts', 'eraty_enqueue_scripts');
function eraty_enqueue_scripts()
{
    wp_register_style('eraty.css', ERATY__PLUGIN_URL . '/inc/eraty.css');
    wp_enqueue_style('eraty.css');

    wp_register_script('eraty.js', ERATY__PLUGIN_URL . '/inc/eraty.js', array('jquery'));

    $script_data = array(
        'shop_id' => get_option('eraty_shop_id'),
        'evaluate_url' => ERATY__EVALUATE_URL
    );

    wp_localize_script('eraty.js', 'data', $script_data);
    wp_enqueue_script('eraty.js');
}

add_filter('query_vars', 'add_query_vars');
function add_query_vars($aVars) {
    $aVars[] = "eraty-przekierowanie";
    $aVars[] = "eraty_order_id";
    return $aVars;
}

add_action('init',  'eraty_rewrite_rule');
function eraty_rewrite_rule() {
    add_rewrite_rule('^eraty-przekierowanie/([^/]+)/?$', 'index.php?eraty-przekierowanie=1&eraty_order_id=$matches[1]', 'top');
    flush_rewrite_rules();
}

add_action('template_redirect',  'eraty_template_redirect');
function eraty_template_redirect() {
    global $wp_query;

    if (isset($wp_query->query_vars['eraty-przekierowanie'])) {
        $order_id = isset($wp_query->query_vars['eraty_order_id']) ? $wp_query->query_vars['eraty_order_id'] : null;
        eraty_redirect_page($order_id);
        exit();
    }
}

function eraty_redirect_page($order_id) {
    global $woocommerce;
    $session_customer = WC()->session->get('customer');

    $order = wc_get_order($order_id);

    if(!$order || $session_customer['email'] !== $order->get_billing_email()) {
        wp_safe_redirect( home_url('/') );
        exit;
    }

    $total = format_price($woocommerce->cart->total);

    $items = $order->get_items();

    $params = array(
        'wartoscTowarow' => $total,
        'liczbaSztukTowarow' => count($items),
        'numerSklepu' => get_option('eraty_shop_id'),
        'typProduktu' => '0',
        'nrZamowieniaSklep' => $order_id,
        'sposobDostarczeniaTowaru' => 'Przesyłka',
        'blokadaWplaty' => 0,

        'pesel' => null,
        'imie' => $order->get_billing_first_name(),
        'nazwisko' => $order->get_billing_last_name(),
        'email' => $order->get_billing_email(),
        'telKontakt' => $order->get_billing_phone(),
        'ulica' => $order->get_billing_address_1(),
        'nrDomu' => $order->get_billing_address_2(),
        'nrMieszkania' => null,
        'miasto' => $order->get_billing_city(),
        'kodPocz' => $order->get_billing_postcode(),

        'char' => 'ISO',
        'wniosekZapisany' => str_replace( 'https:', 'http:', add_query_arg(array(
                'wc-api' => 'WC_Gateway_Eraty',
                'status' => 'saved',
                'order_id' => $order_id,
                'application_id' => ''
            ), home_url( '/' ) ) ) . '=',
        'wniosekAnulowany' => str_replace( 'https:', 'http:', add_query_arg(array(
                'wc-api' => 'WC_Gateway_Eraty',
                'status' => 'cancelled',
                'order_id' => $order_id,
                'application_id' => ''
            ), home_url( '/' ) ) ) . '=',
    );

    $productsTotal = 0;
    $nr = 0;
    foreach($items as $item) {

        $itemPrice = format_price($item->get_total() + $item->get_total_tax());

        if($itemPrice > 0){
            $nr++;

            $params['idTowaru' . $nr] = $item->get_product_id();;
            $params['nazwaTowaru' . $nr] = $item->get_name();
            $params['liczbaSztukTowaru' . $nr] = $item->get_quantity();
            $params['wartoscTowaru' . $nr] = $itemPrice;
            $params['jednostkaTowaru' . $nr] = 'sztuki';

            $productsTotal += $itemPrice;
        }

    }


    if (($shipping = format_price($order->get_shipping_total())) && $shipping > 0)
    {
        if(format_price($productsTotal + $shipping) != $total){
            $shipping = format_price($productsTotal - $total);
            if($shipping < 1){
                $shipping = format_price($total - $productsTotal);
            }
        }
        $nr++;
        $params['idTowaru' . $nr] = 'KosztPrzesylki';
        $params['nazwaTowaru' . $nr] = 'Koszt przesylki';
        $params['liczbaSztukTowaru' . $nr] = 1;
        $params['wartoscTowaru' . $nr] = $shipping;
        $params['jednostkaTowaru' . $nr] = 'sztuki';
    }

    echo '<form id="eratyform" action="' . ERATY__FORM_URL . '" method="post">';
    foreach ($params as $key => $param){
        echo '<input type="hidden" name="'.$key.'" value="'.$param.'">';
    }
    echo '</form>';
    echo '<script>

            var eratyRedirectDiv = document.createElement("div");
            eratyRedirectDiv.id = "eraty-redirect";
            eratyRedirectDiv.textContent = "Trwa przekierowanie";
            
            eratyRedirectDiv.style.backgroundColor = "white";
            eratyRedirectDiv.style.color = "black";
            eratyRedirectDiv.style.position = "fixed";
            eratyRedirectDiv.style.zIndex = "999";
            eratyRedirectDiv.style.width = "100%";
            eratyRedirectDiv.style.height = "100%";
            
            document.body.prepend(eratyRedirectDiv);
            
            document.getElementById("eratyform").submit();

            </script>
            ';
}
