<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

if (! wp_next_scheduled ( 'eraty_hourly' )) {
    wp_schedule_event(time(), 'hourly', 'eraty_hourly');
}

add_action('eraty_hourly', 'updateOrdersStatus');

function updateOrdersStatus() {
    $query = new WC_Order_Query( [
        'limit' => -1,
        'payment_method' => 'eraty',
        'status' => 'on-hold',
    ] );
    $orders = $query->get_orders();
    foreach($orders as $order){

        $status = checkApplicationStatus($order->get_id());
        if($status){
            switch ($status){
                case 'success':
                    $eraty_status = __("Decyzja: Pozytywna", 'eraty' );
                    $woocommerce_status = 'completed';
                    break;
                case 'in_progress':
                    $eraty_status = __("Decyzja: Nie ma jeszcze decyzji", 'eraty' );
                    $woocommerce_status = 'on-hold';
                    break;
                case 'check_manually':
                    $eraty_status = __("Decyzja: Brak informacji - sprawdź w Panelu Ewidencji Wniosków", 'eraty' );
                    $woocommerce_status = 'on-hold';
                    break;
                case 'failed':
                    $eraty_status = __("Decyzja: Negatywna", 'eraty' );
                    $woocommerce_status = 'cancelled';
                    break;
            }

            $order->update_status($woocommerce_status, $eraty_status, true);
            $order->save();
        }

    }

}

function checkApplicationStatus($order_id){
    $shop_cert_file_name = get_option('eraty_shop_cert_file_name');
    $shop_cert_password = get_option('eraty_shop_cert');
    $shop_api_login = get_option('eraty_webservice_login');
    $shop_api_password = get_option('eraty_webservice_password');
    $shop_id = get_option('eraty_shop_id');

    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://api.santanderconsumer.pl/ProposalServiceHybrid',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS =>'<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:san="http://santanderconsumerbank.pl/" xmlns:obj="http://santanderconsumerbank.pl/objects" xmlns:arr="http://schemas.microsoft.com/2003/10/Serialization/Arrays">
           <soapenv:Body>
              <san:GetApplicationState>
                <san:Identity>
                    <obj:Login>'.$shop_api_login.'</obj:Login>
                    <obj:Password>'.$shop_api_password.'</obj:Password>
                    <obj:ShopNumber>'.$shop_id.'</obj:ShopNumber>
                 </san:Identity>
                 <san:ShopApplicationNumbers>
                    <arr:string>'.$order_id.'</arr:string>
                 </san:ShopApplicationNumbers>
              </san:GetApplicationState>
           </soapenv:Body>
        </soapenv:Envelope>',
        CURLOPT_HTTPHEADER => array(
            'Content-Type: text/xml',
            'SOAPAction: http://santanderconsumerbank.pl/IProposalServiceHybrid/GetApplicationState'
        ),
        CURLOPT_SSLCERTTYPE => 'P12',
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_SSLCERT => WP_CONTENT_DIR . '/'.$shop_cert_file_name,
        CURLOPT_SSLCERTPASSWD => $shop_cert_password,
    ));

    $response = curl_exec($curl);

    if (curl_errno($curl)) {
        return null;
    }

    curl_close($curl);

    if (str_contains($response, '<a:CreditState>Wydaj_towar</a:CreditState>')) {
        return 'success';
    }elseif(str_contains($response, '<a:CreditState>Bank</a:CreditState>')) {
        return 'in_progress';
    }elseif(str_contains($response, '<a:CreditState>Klient</a:CreditState>')) {
        return 'in_progress';
    }elseif(str_contains($response, '<a:CreditState>Odmowa</a:CreditState>')) {
        return 'failed';
    }
    return 'check_manually';
}