<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

add_filter('woocommerce_after_add_to_cart_button', 'eraty_product_evaluate_button');

function eraty_product_evaluate_button(){
    global $product;

    render_evaluate_button(wc_get_price_including_tax($product));
}

add_action('woocommerce_proceed_to_checkout', 'eraty_basket_evaluate_button');

function eraty_basket_evaluate_button() {
    global $woocommerce;

    render_evaluate_button($woocommerce->cart->total);
}

function render_evaluate_button($value){
    if (priceIsValidated($value)) {
        ?>

        <button type="button" class="eraty-image-button eraty-evaluate-button" data-eraty-value="<?php echo $value; ?>">
            <img src="<?php echo ERATY__PLUGIN_URL; ?>/images/evaluate.png" title="<?php echo __('Oblicz ratę', 'eraty'); ?>" alt="<?php echo __('Oblicz ratę', 'eraty'); ?>" border="0" />
        </button>

        <?php
    }
}

function render_terms_button(){
    ?>

    <button type="button" class="eraty-image-button eraty-terms-button">
        <img src="<?php echo ERATY__PLUGIN_URL; ?>/images/how.png" title="<?php echo __('Jak kupić', 'eraty'); ?>" alt="<?php echo __('Jak kupić', 'eraty'); ?>" border="0" />
    </button>

    <?php
}

function eraty_enqueue_scripts()
{
    wp_register_style('eraty.css', ERATY__PLUGIN_URL . '/inc/eraty.css');
    wp_enqueue_style('eraty.css');

    wp_register_script('eraty.js', ERATY__PLUGIN_URL . '/inc/eraty.js', array('jquery'));

    $script_data = array(
        'shop_id' => get_option('eraty_shop_id'),
        'evaluate_url' => ERATY__EVALUATE_URL
    );

    wp_localize_script('eraty.js', 'data', $script_data);
    wp_enqueue_script('eraty.js');
}

add_action('wp_enqueue_scripts', 'eraty_enqueue_scripts');
