<?php
/**
 * Plugin Name: eRaty
 * Description: eRaty system integration for WooCommerce
 * Version: 1.2.6
 * Author: I&B
 * WC requires at least: 7.5
 */
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

define('ERATY__PLUGIN_DIR', plugin_dir_path( __FILE__ ));
define('ERATY__PLUGIN_URL', plugins_url('',  __FILE__ ));
define('ERATY__EVALUATE_URL', 'https://wniosek.eraty.pl/symulator/oblicz');
define('ERATY__FORM_URL', 'https://wniosek.eraty.pl/formularz');
define('ERATY__MIN_AMOUNT', 100);


function issetShopId(){
    return !empty(get_option( 'eraty_shop_id' )) && strlen(get_option( 'eraty_shop_id' )) > 3;
}

function priceIsValidated($price){
    $minPrice = !empty(get_option( 'eraty_min_price')) ? get_option( 'eraty_min_price') : ERATY__MIN_AMOUNT;
    $maxPrice = !empty(get_option( 'eraty_max_price')) && get_option( 'eraty_max_price') > ERATY__MIN_AMOUNT  ? get_option( 'eraty_max_price') : null;
    $minPriceIsValidated = $price > $minPrice;
    $maxPriceIsValidated = $maxPrice ? $price < $maxPrice : true;

    return $minPriceIsValidated && $maxPriceIsValidated && issetShopId();
}

if(!issetShopId()){
    function eraty_shop_id_required_alert(){
        echo '<div class="error"><p>';
        _e("Wtyczka <strong>eRaty</strong> nie została skonfigurowana. Przejdź do ustawień i dodaj numer sklepu.", 'eraty' );
        echo '</p></div>';
    }
    add_action('admin_notices', 'eraty_shop_id_required_alert');
}

if (!in_array('woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ))) && !in_array('woocommerce/woocommerce.php', array_keys(get_network_option(null, 'active_sitewide_plugins' ) ?: []))){
    function eraty_woocommerce_required_alert(){
        echo '<div class="error"><p>';
        _e("Wtyczka <strong>eRaty</strong> nie może działać bez aktywacji <strong>WooCommerce</strong>. Zainstaluj i aktywuj wtyczkę WooCommerce.", 'eraty' );
        echo '</p></div>';
    }
    add_action('admin_notices', 'eraty_woocommerce_required_alert');
}else{
    require_once( ERATY__PLUGIN_DIR . 'inc/eraty-schedule.php' );
    require_once( ERATY__PLUGIN_DIR . 'inc/eraty-admin.php' );
    require_once( ERATY__PLUGIN_DIR . 'inc/eraty-front.php' );
    require_once( ERATY__PLUGIN_DIR . 'inc/wc-gateway-eraty.php' );
}
